/**
 * Email Notification Service
 * Handles email notifications for the crypto exchange
 */

class EmailService {
    private static $smtp_host;
    private static $smtp_port;
    private static $smtp_username;
    private static $smtp_password;
    private static $from_email;
    private static $from_name;
    
    public static function initialize() {
        require_once __DIR__ . '/../config/env.php';
        EnvConfig::load(__DIR__ . '/../config.env');
        
        self::$smtp_host = EnvConfig::get('SMTP_HOST', 'smtp.gmail.com');
        self::$smtp_port = EnvConfig::get('SMTP_PORT', 587);
        self::$smtp_username = EnvConfig::get('SMTP_USERNAME');
        self::$smtp_password = EnvConfig::get('SMTP_PASSWORD');
        self::$from_email = EnvConfig::get('SMTP_FROM_EMAIL', 'noreply@yellowcrypto.com');
        self::$from_name = EnvConfig::get('SMTP_FROM_NAME', 'YELLOW Crypto Exchange');
    }
    
    public static function sendWelcomeEmail($user_email, $user_name) {
        $subject = "Welcome to YELLOW Crypto Exchange!";
        $body = "
        <html>
        <body>
            <h2>Welcome to YELLOW Crypto Exchange!</h2>
            <p>Dear {$user_name},</p>
            <p>Thank you for joining YELLOW Crypto Exchange. Your account has been successfully created.</p>
            <p>You can now:</p>
            <ul>
                <li>Buy and sell cryptocurrencies</li>
                <li>Send and receive crypto</li>
                <li>Track your portfolio</li>
                <li>Access our trading features</li>
            </ul>
            <p>If you have any questions, please contact our support team.</p>
            <p>Best regards,<br>YELLOW Crypto Exchange Team</p>
        </body>
        </html>
        ";
        
        return self::sendEmail($user_email, $subject, $body);
    }
    
    public static function sendTransactionNotification($user_email, $transaction_type, $amount, $currency) {
        $subject = "Transaction Notification - {$transaction_type}";
        $body = "
        <html>
        <body>
            <h2>Transaction Notification</h2>
            <p>Your {$transaction_type} transaction has been processed:</p>
            <p><strong>Amount:</strong> {$amount} {$currency}</p>
            <p><strong>Status:</strong> Completed</p>
            <p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>
            <p>You can view more details in your account dashboard.</p>
            <p>Best regards,<br>YELLOW Crypto Exchange Team</p>
        </body>
        </html>
        ";
        
        return self::sendEmail($user_email, $subject, $body);
    }
    
    public static function sendSecurityAlert($user_email, $alert_type, $details) {
        $subject = "Security Alert - {$alert_type}";
        $body = "
        <html>
        <body>
            <h2>Security Alert</h2>
            <p>We detected unusual activity on your account:</p>
            <p><strong>Alert Type:</strong> {$alert_type}</p>
            <p><strong>Details:</strong> {$details}</p>
            <p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>
            <p>If this was not you, please contact our support team immediately.</p>
            <p>Best regards,<br>YELLOW Crypto Exchange Security Team</p>
        </body>
        </html>
        ";
        
        return self::sendEmail($user_email, $subject, $body);
    }
    
    private static function sendEmail($to, $subject, $body) {
        try {
            // For development, just log the email
            if (EnvConfig::get('APP_ENV') === 'development') {
                error_log("EMAIL TO: {$to}");
                error_log("EMAIL SUBJECT: {$subject}");
                error_log("EMAIL BODY: {$body}");
                return true;
            }
            
            // In production, use actual SMTP
            if (!self::$smtp_username || !self::$smtp_password) {
                error_log("SMTP credentials not configured");
                return false;
            }
            
            // Use PHPMailer or similar in production
            // For now, return true for development
            return true;
            
        } catch (Exception $e) {
            error_log("Email sending failed: " . $e->getMessage());
            return false;
        }
    }
}

// Initialize the service
EmailService::initialize();
