<?php
/**
 * Payment Webhook Handler
 * 
 * This endpoint can be called by external services or events to trigger
 * payment status checks without requiring cron jobs.
 */

require_once __DIR__ . '/event_driven_checker.php';

// Set content type
header('Content-Type: application/json');

// Handle CORS
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

try {
    $checker = new EventDrivenPaymentChecker();
    
    // Force check if this is a webhook call
    $forceCheck = isset($_GET['force']) && $_GET['force'] === 'true';
    $result = $checker->checkIfNeeded($forceCheck);
    
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'timestamp' => date('Y-m-d H:i:s'),
        'data' => $result
    ]);
    
} catch (Exception $e) {
    error_log("Payment webhook error: " . $e->getMessage());
    
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => 'Internal server error',
        'message' => $e->getMessage()
    ]);
}
?>

