<?php
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/api/blockchain_manager.php';

echo "🔍 Testing Transaction Logic\n";
echo "============================\n\n";

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $user_id = 1;
    $currency = 'USDT';
    $amount = 100;
    $currentPrice = 3750;
    $cryptoAmount = $amount / $currentPrice;
    $fee = $cryptoAmount * 0.01;
    $totalCryptoAmount = $cryptoAmount - $fee;
    
    echo "Starting transaction test...\n";
    echo "Total crypto amount: $totalCryptoAmount\n";
    
    // Start transaction
    $conn->beginTransaction();
    echo "✅ Transaction started\n";
    
    try {
        // Test deducting fiat balance
        $stmt = $conn->prepare("
            UPDATE user_fiat_balances 
            SET balance = balance - ? 
            WHERE user_id = ? AND currency_code = 'UGX'
        ");
        $result = $stmt->execute([$amount, $user_id]);
        echo "✅ Fiat balance deduction: " . ($result ? 'success' : 'failed') . "\n";
        
        // Test deducting from system wallet
        $stmt = $conn->prepare("
            UPDATE crypto_wallets 
            SET balance = balance - ?, updated_at = CURRENT_TIMESTAMP
            WHERE id = 3
        ");
        $result = $stmt->execute([$totalCryptoAmount]);
        echo "✅ System wallet deduction: " . ($result ? 'success' : 'failed') . "\n";
        
        // Test BlockchainManager
        echo "\n🔗 Testing BlockchainManager...\n";
        $blockchain = new BlockchainManager($db);
        echo "✅ BlockchainManager created\n";
        
        // Test wallet address generation
        $address = $blockchain->generateRealWallet($currency, 'erc20');
        if ($address && isset($address['address'])) {
            echo "✅ Wallet address generated: " . substr($address['address'], 0, 20) . "...\n";
        } else {
            echo "❌ Failed to generate wallet address\n";
        }
        
        // Test transaction hash generation
        $txHash = 'buy_' . time() . '_' . $user_id . '_' . bin2hex(random_bytes(16));
        echo "✅ Transaction hash generated: " . substr($txHash, 0, 30) . "...\n";
        
        // Test inserting crypto transaction
        $stmt = $conn->prepare("
            INSERT INTO crypto_transactions (wallet_id, user_id, network, currency, address, tx_hash, amount, type, status, created_at)
            VALUES (?, ?, 'erc20', ?, ?, ?, ?, 'buy', 'confirmed', CURRENT_TIMESTAMP)
        ");
        $result = $stmt->execute([3, $user_id, $currency, $address['address'] ?? 'test_address', $txHash, $totalCryptoAmount]);
        echo "✅ Crypto transaction insert: " . ($result ? 'success' : 'failed') . "\n";
        
        // Commit transaction
        $conn->commit();
        echo "✅ Transaction committed successfully\n";
        
    } catch (Exception $e) {
        $conn->rollback();
        echo "❌ Transaction rolled back: " . $e->getMessage() . "\n";
        throw $e;
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
?>

