<?php
// Debug wallet generation
require_once __DIR__ . '/config/database.php';
require_once __DIR__ . '/wallet_generator.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    $walletGenerator = new WalletGenerator($conn);
    $result = $walletGenerator->generateWallet(1, 'trc20', 'USDT');
    
    echo "Result: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
?>

