<?php
/**
 * Simple Example: Replace USDT ERC20 Wallet with Your Own
 * 
 * This is a simple example showing how to replace one system wallet
 * with your own wallet address and private key.
 */

require_once 'config/env.php';
require_once 'config/database.php';

// Load environment
EnvConfig::load(__DIR__ . '/config.env');

// Your wallet details (REPLACE WITH YOUR ACTUAL DETAILS)
$yourUSDTAddress = '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6'; // Binance USDT address
$yourUSDTPrivateKey = 'your_private_key_here'; // Your actual private key

// Encrypt your private key
function encryptPrivateKey($privateKey) {
    $jwtSecret = EnvConfig::get('JWT_SECRET');
    $hash = hash('sha256', $jwtSecret);
    return base64_encode($privateKey . '|' . $hash);
}

// Replace the wallet
try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Encrypt your private key
    $encryptedKey = encryptPrivateKey($yourUSDTPrivateKey);
    
    // Update the database
    $stmt = $conn->prepare("
        UPDATE crypto_wallets 
        SET address = ?, private_key = ?, updated_at = CURRENT_TIMESTAMP
        WHERE user_id = 0 AND currency = 'USDT' AND network = 'ERC20'
    ");
    
    $result = $stmt->execute([$yourUSDTAddress, $encryptedKey]);
    
    if ($result) {
        echo "✅ USDT ERC20 wallet replaced successfully!\n";
        echo "New address: {$yourUSDTAddress}\n";
        echo "Encrypted private key: {$encryptedKey}\n";
    } else {
        echo "❌ Failed to replace wallet\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}

echo "\n📋 NEXT STEPS:\n";
echo "1. Fund your new wallet with USDT\n";
echo "2. Test a small transaction\n";
echo "3. Monitor the wallet balance\n";
echo "4. Update production config if needed\n";
?>
