<?php
/**
 * System Wallet Funding Helper
 * Helps fund the system wallet and test transactions
 */

echo "💰 SYSTEM WALLET FUNDING HELPER\n";
echo "===============================\n\n";

// System wallet details
$systemWallet = 'TBLeTtDbm9A5jUJcyKqF4JUkv5tySd4cde';

echo "🔍 Current System Wallet Status:\n";
echo "   Address: {$systemWallet}\n";
echo "   TronScan: https://tronscan.org/#/address/{$systemWallet}\n\n";

// Check current balance
echo "📊 Checking current balance...\n";
$balanceUrl = "https://api.trongrid.io/v1/accounts/{$systemWallet}";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $balanceUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200 && $response) {
    $data = json_decode($response, true);
    if ($data && isset($data['data'][0])) {
        $account = $data['data'][0];
        $balance = $account['balance'] ?? 0;
        $usdtBalance = 0;
        
        if (isset($account['trc20'])) {
            foreach ($account['trc20'] as $token) {
                if ($token['TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t']) {
                    $usdtBalance = $token['TR7NHqjeKQxGTCi8q8ZY4pL8otSzgjLj6t'] / 1000000;
                    break;
                }
            }
        }
        
        echo "📈 Current Balance:\n";
        echo "   TRX: {$balance} TRX\n";
        echo "   USDT: {$usdtBalance} USDT\n\n";
        
        if ($balance < 20) {
            echo "⚠️  INSUFFICIENT TRX BALANCE!\n";
            echo "   Current: {$balance} TRX\n";
            echo "   Required: 20+ TRX\n";
            echo "   Shortage: " . (20 - $balance) . " TRX\n\n";
            
            echo "💡 FUNDING OPTIONS:\n";
            echo "   1. Buy TRX from exchange and send to wallet\n";
            echo "   2. Use TRX faucet (if available)\n";
            echo "   3. Ask team members for test TRX\n";
            echo "   4. Use testnet for development\n\n";
            
            echo "🔗 Quick Links:\n";
            echo "   TronScan: https://tronscan.org/#/address/{$systemWallet}\n";
            echo "   Binance: https://www.binance.com/en/trade/TRX_USDT\n";
            echo "   Coinbase: https://www.coinbase.com/price/tron\n\n";
            
        } else {
            echo "✅ TRX balance is sufficient for transactions!\n";
            echo "   You can now test transactions.\n\n";
        }
        
    } else {
        echo "❌ Failed to parse balance data\n";
    }
} else {
    echo "❌ Failed to check balance (HTTP {$httpCode})\n";
}

echo "🧪 TEST TRANSACTION (after funding):\n";
echo "   curl -X POST http://localhost:8000/api/crypto/send-to-wallet \\\n";
echo "     -H \"Content-Type: application/json\" \\\n";
echo "     -d '{\"wallet_id\": 82, \"recipient\": \"TDi5wcsHDTW75qWQjugFDDd1o1ExuEP1Y7\", \"amount\": 0.26, \"currency\": \"USDT\", \"network\": \"trc20\"}' \\\n";
echo "     -H \"Authorization: Bearer test-token\"\n\n";

echo "📝 Note: This system wallet is used for processing all crypto transactions.\n";
echo "   It needs TRX to pay for transaction fees on the Tron network.\n";
?>







