// Breadcrumb Navigation System
const pageBreadcrumbs = {
    'user_dashboard.html': { title: 'Dashboard', parent: null },
    'market_overview.html': { title: 'Markets', parent: 'user_dashboard.html' },
    'buy.html': { title: 'Buy & Sell', parent: 'user_dashboard.html' },
    'crypto_wallet.html': { title: 'Wallet', parent: 'user_dashboard.html' },
    'user_profile_&_kyc.html': { title: 'Profile & KYC', parent: 'user_dashboard.html' },
    'transaction_history.html': { title: 'Transaction History', parent: 'user_dashboard.html' },
    'deposit.html': { title: 'Deposit Funds', parent: 'user_dashboard.html' },
    'withdraw_to_bank_account.html': { title: 'Withdraw Funds', parent: 'user_dashboard.html' },
    'security_settings_&_2fa.html': { title: 'Security Settings', parent: 'user_dashboard.html' },
    'notification_settings.html': { title: 'Notifications', parent: 'security_settings_&_2fa.html' },
    'manage_local_currencies.html': { title: 'Manage Currencies', parent: 'crypto_wallet.html' },
    'help_&_support.html': { title: 'Help & Support', parent: 'user_dashboard.html' }
};

function getBreadcrumbPath() {
    const currentPage = window.location.pathname.split('/').pop();
    const path = [];
    let current = pageBreadcrumbs[currentPage];
    
    while (current) {
        path.unshift({ title: current.title, url: current.parent });
        current = current.parent ? pageBreadcrumbs[current.parent] : null;
    }
    
    return path;
}

function createBreadcrumbHTML() {
    const path = getBreadcrumbPath();
    if (path.length <= 1) return '';
    
    let html = '<div class="flex items-center text-sm text-gray-500 dark:text-gray-400 mb-2">';
    
    path.forEach((item, index) => {
        if (index > 0) {
            html += '<span class="material-symbols-outlined text-xs mx-1">chevron_right</span>';
        }
        
        if (index === path.length - 1) {
            // Current page
            html += `<span class="text-gray-700 dark:text-gray-300 font-medium">${item.title}</span>`;
        } else {
            // Parent page
            html += `<a href="${item.url}" class="hover:text-primary transition-colors">${item.title}</a>`;
        }
    });
    
    html += '</div>';
    return html;
}

// Auto-inject breadcrumbs into pages
document.addEventListener('DOMContentLoaded', function() {
    const breadcrumbHTML = createBreadcrumbHTML();
    if (breadcrumbHTML) {
        // Find the main content area and inject breadcrumbs
        const main = document.querySelector('main');
        if (main) {
            main.insertAdjacentHTML('afterbegin', breadcrumbHTML);
        }
    }
});
