// Smart Back Navigation System for KudiKoin
function smartBack() {
    // Check if there's history to go back to
    if (window.history.length > 1) {
        // Check if we came from within the app
        const referrer = document.referrer;
        const currentDomain = window.location.origin;
        
        if (referrer && referrer.startsWith(currentDomain)) {
            // We came from within the app, go back normally
            window.history.back();
        } else {
            // We came from outside or direct link, go to dashboard
            window.location.href = 'user_dashboard.html';
        }
    } else {
        // No history, go to dashboard
        window.location.href = 'user_dashboard.html';
    }
}

// Enhanced back button with visual feedback
function smartBackWithFeedback() {
    const button = event.target.closest('button');
    if (button) {
        // Add visual feedback
        button.style.transform = 'scale(0.95)';
        button.style.opacity = '0.7';
        
        setTimeout(() => {
            button.style.transform = 'scale(1)';
            button.style.opacity = '1';
        }, 150);
    }
    
    // Call the smart back function
    smartBack();
}

// Keyboard navigation support
document.addEventListener('keydown', function(event) {
    // ESC key for back navigation
    if (event.key === 'Escape') {
        smartBack();
    }
    
    // Alt + Left Arrow for back navigation
    if (event.altKey && event.key === 'ArrowLeft') {
        event.preventDefault();
        smartBack();
    }
});

// Add swipe gesture support for mobile
let touchStartX = 0;
let touchEndX = 0;

document.addEventListener('touchstart', function(event) {
    touchStartX = event.changedTouches[0].screenX;
});

document.addEventListener('touchend', function(event) {
    touchEndX = event.changedTouches[0].screenX;
    handleSwipe();
});

function handleSwipe() {
    const swipeThreshold = 50;
    const swipeDistance = touchEndX - touchStartX;
    
    // Swipe right to go back (like iOS)
    if (swipeDistance > swipeThreshold) {
        smartBack();
    }
}

// Page transition effects
function navigateToPage(url) {
    // Add fade out effect
    document.body.style.opacity = '0.8';
    document.body.style.transition = 'opacity 0.2s ease-out';
    
    setTimeout(() => {
        window.location.href = url;
    }, 200);
}

// Initialize page with fade in effect
document.addEventListener('DOMContentLoaded', function() {
    document.body.style.opacity = '0';
    document.body.style.transition = 'opacity 0.3s ease-in';
    
    setTimeout(() => {
        document.body.style.opacity = '1';
    }, 50);
});
