<?php
require_once __DIR__ . "/config/database.php";
require_once __DIR__ . "/api/blockchain_manager.php";

$db = new Database();
$blockchain = new BlockchainManager($db);

// Sync blockchain balances
$result = $blockchain->syncBlockchainBalances();
echo "Blockchain sync: " . ($result["success"] ? "Success" : "Failed") . "\n";

// Check system health
$conn = $db->getConnection();
$stmt = $conn->prepare("SELECT COUNT(*) as count FROM crypto_wallets WHERE user_id = 0");
$stmt->execute();
$system_wallets = $stmt->fetch()["count"];

echo "System wallets: $system_wallets\n";
echo "Monitoring completed at " . date("Y-m-d H:i:s") . "\n";
?>