<?php
require_once __DIR__ . "/config/database.php";

function sendAlert($type, $severity, $message) {
    $conn = (new Database())->getConnection();
    $stmt = $conn->prepare("
        INSERT INTO production_alerts (alert_type, severity, message)
        VALUES (?, ?, ?)
    ");
    $stmt->execute([$type, $severity, $message]);
    
    // In production, also send email/SMS alerts
    echo "ALERT [$severity]: $message\n";
}

// Example alert
sendAlert("system_health", "warning", "System wallet balance below threshold");
?>