<?php

// Simulate the API request
$_SERVER['REQUEST_METHOD'] = 'POST';
$_SERVER['REQUEST_URI'] = '/api/crypto/send-to-wallet';
$_SERVER['HTTP_AUTHORIZATION'] = 'Bearer test-token';

// Simulate the input
$input = [
    'wallet_id' => 1,
    'recipient' => '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
    'amount' => 0.1,
    'currency' => 'USDT',
    'network' => 'erc20'
];

// Capture the input
file_put_contents('php://input', json_encode($input));

echo "Testing API endpoint...\n";

try {
    // Include the API
    require_once 'api/index.php';
} catch (Exception $e) {
    echo "Exception: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
} catch (Error $e) {
    echo "Fatal Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

?>

