<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Test just the handler method
require_once 'config/database.php';
require_once 'api/index.php';

try {
    echo "Creating API instance...\n";
    $api = new API();
    echo "API created successfully\n";
    
    // Test the method directly
    echo "Testing handleCryptoSendToWallet method...\n";
    
    // Set up the request method
    $api->request_method = 'POST';
    $api->user_id = 1;
    
    // Simulate input
    $input = [
        'wallet_id' => 1,
        'recipient' => '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6',
        'amount' => 0.1,
        'currency' => 'USDT',
        'network' => 'erc20'
    ];
    
    // Mock the file_get_contents
    file_put_contents('php://temp', json_encode($input));
    
    // Call the method
    $reflection = new ReflectionClass($api);
    $method = $reflection->getMethod('handleCryptoSendToWallet');
    $method->setAccessible(true);
    $method->invoke($api);
    
} catch (Exception $e) {
    echo "Exception: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
} catch (Error $e) {
    echo "Fatal Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

?>

