<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config/database.php';
require_once 'api/blockchain_manager.php';

try {
    $db = new Database();
    $blockchainManager = new BlockchainManager($db);
    
    $fromAddress = '0x736b96b4b1e6169f4c214d16d30df54054a1bf1c';
    $toAddress = '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6';
    $amount = 0.1;
    $currency = 'USDT';
    $network = 'erc20';
    $privateKeyEncrypted = null;
    
    echo "Testing blockchain transaction:\n";
    echo "From: $fromAddress\n";
    echo "To: $toAddress\n";
    echo "Amount: $amount $currency\n";
    echo "Network: $network\n\n";
    
    $result = $blockchainManager->sendRealTransaction(
        $fromAddress,
        $toAddress,
        $amount,
        $currency,
        $network,
        $privateKeyEncrypted
    );
    
    echo "Result:\n";
    print_r($result);
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

?>
