<?php
// Test blockchain service call
echo "Testing blockchain service call...\n";

$url = 'http://localhost:3001/generate-tron-wallet';
$postData = json_encode(['currency' => 'USDT']);

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postData,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_TIMEOUT => 10
]);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n";

if ($response) {
    $data = json_decode($response, true);
    if ($data && isset($data['address'])) {
        echo "Address: " . $data['address'] . "\n";
        echo "Private Key: " . substr($data['private_key'], 0, 10) . "...\n";
    }
}
?>

