<?php
/**
 * Database Connection Test
 * Test the shared MySQL database connection
 */

require_once 'config/database.php';

echo "🔍 Testing Database Connection to Shared MySQL\n";
echo "=============================================\n\n";

try {
    $db = new Database();
    $conn = $db->getConnection();
    echo "✅ Database connection successful!\n\n";
    
    // Test basic queries
    echo "📊 Testing Database Tables:\n";
    echo "---------------------------\n";
    
    // Test users table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM users');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "👥 Users: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Users table error: " . $e->getMessage() . "\n";
    }
    
    // Test cryptocurrencies table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM cryptocurrencies');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "💰 Cryptocurrencies: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Cryptocurrencies table error: " . $e->getMessage() . "\n";
    }
    
    // Test networks table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM networks');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "🌐 Networks: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Networks table error: " . $e->getMessage() . "\n";
    }
    
    // Test user_wallets table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM user_wallets');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "💳 User Wallets: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ User wallets table error: " . $e->getMessage() . "\n";
    }
    
    // Test transactions table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM transactions');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "📝 Transactions: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Transactions table error: " . $e->getMessage() . "\n";
    }
    
    echo "\n✅ Database connection test completed!\n";
    
} catch (Exception $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    echo "Please check your database configuration in config.env\n";
}
?>
