<?php
/**
 * Database Connection Test with Correct Credentials
 * Test the shared MySQL database connection
 */

echo "🔍 Testing Database Connection to Shared MySQL\n";
echo "=============================================\n";
echo "Database: kakoexchange25_kakoexchange\n";
echo "Username: kakoexchange25_kakoexperience\n";
echo "Password: mtVlJx34t#-5\n\n";

try {
    // Direct PDO connection with correct credentials
    $host = 'localhost';
    $dbname = 'kakoexchange25_kakoexchange';
    $username = 'kakoexchange25_kakoexperience';
    $password = 'mtVlJx34t#-5';
    
    $conn = new PDO(
        "mysql:host={$host};dbname={$dbname};charset=utf8mb4",
        $username,
        $password,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ]
    );
    
    echo "✅ Database connection successful!\n\n";
    
    // Test basic queries
    echo "📊 Testing Database Tables:\n";
    echo "---------------------------\n";
    
    // Test users table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM users');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "👥 Users: " . $result['count'] . "\n";
        
        // Get sample users
        $stmt = $conn->prepare('SELECT id, email, first_name, last_name, country FROM users LIMIT 3');
        $stmt->execute();
        $users = $stmt->fetchAll();
        echo "   Sample users:\n";
        foreach ($users as $user) {
            echo "   - ID: {$user['id']}, Email: {$user['email']}, Name: {$user['first_name']} {$user['last_name']}, Country: {$user['country']}\n";
        }
    } catch (Exception $e) {
        echo "❌ Users table error: " . $e->getMessage() . "\n";
    }
    
    // Test cryptocurrencies table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM cryptocurrencies');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "💰 Cryptocurrencies: " . $result['count'] . "\n";
        
        // Get sample cryptocurrencies
        $stmt = $conn->prepare('SELECT symbol, name FROM cryptocurrencies LIMIT 5');
        $stmt->execute();
        $cryptos = $stmt->fetchAll();
        echo "   Available cryptos:\n";
        foreach ($cryptos as $crypto) {
            echo "   - {$crypto['symbol']}: {$crypto['name']}\n";
        }
    } catch (Exception $e) {
        echo "❌ Cryptocurrencies table error: " . $e->getMessage() . "\n";
    }
    
    // Test networks table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM networks');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "🌐 Networks: " . $result['count'] . "\n";
        
        // Get sample networks
        $stmt = $conn->prepare('SELECT name, symbol, fee_usd FROM networks LIMIT 5');
        $stmt->execute();
        $networks = $stmt->fetchAll();
        echo "   Available networks:\n";
        foreach ($networks as $network) {
            echo "   - {$network['name']} ({$network['symbol']}): \${$network['fee_usd']} fee\n";
        }
    } catch (Exception $e) {
        echo "❌ Networks table error: " . $e->getMessage() . "\n";
    }
    
    // Test user_wallets table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM user_wallets');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "💳 User Wallets: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ User wallets table error: " . $e->getMessage() . "\n";
    }
    
    // Test transactions table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM transactions');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "📝 Transactions: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Transactions table error: " . $e->getMessage() . "\n";
    }
    
    // Test trading_pairs table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM trading_pairs');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "💱 Trading Pairs: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Trading pairs table error: " . $e->getMessage() . "\n";
    }
    
    // Test market_prices table
    try {
        $stmt = $conn->prepare('SELECT COUNT(*) as count FROM market_prices');
        $stmt->execute();
        $result = $stmt->fetch();
        echo "📈 Market Prices: " . $result['count'] . "\n";
    } catch (Exception $e) {
        echo "❌ Market prices table error: " . $e->getMessage() . "\n";
    }
    
    echo "\n✅ Database connection test completed!\n";
    echo "🎯 Database is ready for testing all features!\n";
    
} catch (Exception $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    echo "Please check your database configuration\n";
}
?>
