<?php
echo "🔍 Testing Hash Generation\n";
echo "==========================\n\n";

$hashes = [];

for ($i = 0; $i < 10; $i++) {
    $hash = 'buy_' . microtime(true) . '_1_' . bin2hex(random_bytes(16));
    $hashes[] = $hash;
    echo "Hash $i: " . substr($hash, 0, 50) . "...\n";
    usleep(1000); // Small delay to ensure microtime changes
}

echo "\nChecking for duplicates...\n";
$unique_hashes = array_unique($hashes);
if (count($hashes) === count($unique_hashes)) {
    echo "✅ All hashes are unique!\n";
} else {
    echo "❌ Found " . (count($hashes) - count($unique_hashes)) . " duplicate hashes\n";
}

echo "\nTesting database insertion...\n";

try {
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Test inserting a unique hash
    $test_hash = 'test_' . microtime(true) . '_' . bin2hex(random_bytes(16));
    
    $stmt = $conn->prepare("
        INSERT INTO crypto_transactions (wallet_id, user_id, network, currency, address, tx_hash, amount, type, status, created_at)
        VALUES (1, 1, 'erc20', 'USDT', '0x1234567890abcdef', ?, 0.001, 'test', 'confirmed', CURRENT_TIMESTAMP)
    ");
    
    $result = $stmt->execute([$test_hash]);
    
    if ($result) {
        echo "✅ Test transaction inserted successfully\n";
        echo "   Hash: " . substr($test_hash, 0, 50) . "...\n";
        
        // Clean up test transaction
        $stmt = $conn->prepare("DELETE FROM crypto_transactions WHERE tx_hash = ?");
        $stmt->execute([$test_hash]);
        echo "✅ Test transaction cleaned up\n";
    } else {
        echo "❌ Failed to insert test transaction\n";
    }
    
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "\n";
}
?>

