<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Starting test...\n";

try {
    echo "Loading database...\n";
    require_once 'config/database.php';
    $db = new Database();
    echo "Database loaded successfully\n";
    
    echo "Loading blockchain manager...\n";
    require_once 'api/blockchain_manager.php';
    echo "BlockchainManager class loaded\n";
    
    echo "Creating BlockchainManager instance...\n";
    $blockchainManager = new BlockchainManager($db);
    echo "BlockchainManager created successfully\n";
    
    echo "Testing public method call...\n";
    $result = $blockchainManager->generateRealWallet('USDT', 'ERC20');
    echo "generateRealWallet result: " . json_encode($result) . "\n";
    
} catch (Exception $e) {
    echo "Exception: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
} catch (Error $e) {
    echo "Fatal Error: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "Test completed.\n";

?>
