<?php
/**
 * Test V2 Blockchain APIs
 * Test the updated V2 endpoints
 */

require_once 'config/env.php';

echo "🚀 V2 Blockchain API Testing\n";
echo "=============================\n\n";

// Load environment configuration
EnvConfig::load();

$etherscanKey = EnvConfig::get('ETHERSCAN_API_KEY');
$bscscanKey = EnvConfig::get('BSCSCAN_API_KEY');
$polygonscanKey = EnvConfig::get('POLYGONSCAN_API_KEY');

$testAddress = '0x742d35Cc6634C0532925a3b8D4C9db96C4b4d8b6';

echo "🔍 Test 1: Etherscan V2 API\n";
echo "===========================\n";

$etherscanUrl = "https://api.etherscan.io/v2?module=account&action=balance&address=$testAddress&tag=latest&apikey=$etherscanKey";
echo "URL: $etherscanUrl\n";

$response = file_get_contents($etherscanUrl);
if ($response !== false) {
    $data = json_decode($response, true);
    echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";
    
    if (isset($data['result']) && $data['status'] === '1') {
        $balance = hexdec($data['result']) / pow(10, 18);
        echo "✅ ETH Balance: $balance ETH\n";
    } else {
        echo "❌ Error: " . ($data['message'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Request failed\n";
}

echo "\n🔍 Test 2: BSCScan V2 API\n";
echo "==========================\n";

$bscscanUrl = "https://api.bscscan.com/v2?module=account&action=balance&address=$testAddress&tag=latest&apikey=$bscscanKey";
echo "URL: $bscscanUrl\n";

$response = file_get_contents($bscscanUrl);
if ($response !== false) {
    $data = json_decode($response, true);
    echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";
    
    if (isset($data['result']) && $data['status'] === '1') {
        $balance = hexdec($data['result']) / pow(10, 18);
        echo "✅ BNB Balance: $balance BNB\n";
    } else {
        echo "❌ Error: " . ($data['message'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Request failed\n";
}

echo "\n🔍 Test 3: PolygonScan V2 API\n";
echo "==============================\n";

$polygonscanUrl = "https://api.polygonscan.com/v2?module=account&action=balance&address=$testAddress&tag=latest&apikey=$polygonscanKey";
echo "URL: $polygonscanUrl\n";

$response = file_get_contents($polygonscanUrl);
if ($response !== false) {
    $data = json_decode($response, true);
    echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";
    
    if (isset($data['result']) && $data['status'] === '1') {
        $balance = hexdec($data['result']) / pow(10, 18);
        echo "✅ MATIC Balance: $balance MATIC\n";
    } else {
        echo "❌ Error: " . ($data['message'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Request failed\n";
}

echo "\n⛽ Test 4: Gas Prices V2\n";
echo "========================\n";

$gasUrl = "https://api.etherscan.io/v2?module=gastracker&action=gasoracle&apikey=$etherscanKey";
echo "Gas URL: $gasUrl\n";

$response = file_get_contents($gasUrl);
if ($response !== false) {
    $data = json_decode($response, true);
    echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";
    
    if (isset($data['result']) && $data['status'] === '1') {
        $result = $data['result'];
        echo "✅ Gas Prices:\n";
        echo "   Slow: " . $result['SafeGasPrice'] . " Gwei\n";
        echo "   Standard: " . $result['ProposeGasPrice'] . " Gwei\n";
        echo "   Fast: " . $result['FastGasPrice'] . " Gwei\n";
    } else {
        echo "❌ Error: " . ($data['message'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Request failed\n";
}

echo "\n🎯 Test 5: USDT Token Balance V2\n";
echo "=================================\n";

$usdtContract = '0xdAC17F958D2ee523a2206206994597C13D831ec7';
$tokenUrl = "https://api.etherscan.io/v2?module=account&action=tokenbalance&contractaddress=$usdtContract&address=$testAddress&tag=latest&apikey=$etherscanKey";
echo "Token URL: $tokenUrl\n";

$response = file_get_contents($tokenUrl);
if ($response !== false) {
    $data = json_decode($response, true);
    echo "Response: " . json_encode($data, JSON_PRETTY_PRINT) . "\n";
    
    if (isset($data['result']) && $data['status'] === '1') {
        $balance = hexdec($data['result']) / pow(10, 6); // USDT has 6 decimals
        echo "✅ USDT Balance: $balance USDT\n";
    } else {
        echo "❌ Error: " . ($data['message'] ?? 'Unknown error') . "\n";
    }
} else {
    echo "❌ Request failed\n";
}

echo "\n🎉 V2 API Testing Completed!\n";
?>

