<?php
// Test wallet generator directly
echo "Testing wallet generator directly...\n";

try {
    require_once __DIR__ . '/config/database.php';
    require_once __DIR__ . '/api/wallet_generator.php';
    
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "Creating wallet generator...\n";
    $walletGenerator = new WalletGenerator($conn);
    
    echo "Generating wallet...\n";
    $result = $walletGenerator->generateWallet(1, 'trc20', 'USDT');
    
    echo "Result: " . json_encode($result, JSON_PRETTY_PRINT) . "\n";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
?>

