<?php
// Test wallet generation directly
require_once __DIR__ . '/config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    echo "Database connection successful\n";
    
    // Test inserting a wallet
    $stmt = $conn->prepare("
        INSERT INTO crypto_wallets (user_id, network, currency, address, qr_code, private_key, balance, is_real_blockchain, private_key_encrypted)
        VALUES (?, ?, ?, ?, ?, ?, 0, 1, ?)
    ");
    
    $result = $stmt->execute([
        1,
        'trc20',
        'USDT',
        'TEST_ADDRESS_123',
        'https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=TEST_ADDRESS_123',
        'test_private_key',
        'test_private_key'
    ]);
    
    if ($result) {
        echo "Wallet inserted successfully. ID: " . $conn->lastInsertId() . "\n";
    } else {
        echo "Failed to insert wallet\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>

