<?php
// Test wallet generation process
echo "Testing wallet generation process...\n";

try {
    require_once __DIR__ . '/config/database.php';
    $db = new Database();
    $conn = $db->getConnection();
    
    // Simulate blockchain service response
    $blockchainResponse = [
        'success' => true,
        'address' => 'TEST_ADDRESS_456',
        'private_key' => 'test_private_key_456',
        'network' => 'tron',
        'currency' => 'USDT'
    ];
    
    echo "Blockchain response: " . json_encode($blockchainResponse) . "\n";
    
    // Generate QR code
    $qrCode = 'https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=' . urlencode($blockchainResponse['address']);
    echo "QR Code: $qrCode\n";
    
    // Prepare wallet data
    $walletData = [
        'address' => $blockchainResponse['address'],
        'qr_code' => $qrCode,
        'private_key' => $blockchainResponse['private_key'],
        'network' => 'trc20'
    ];
    
    echo "Wallet data: " . json_encode($walletData) . "\n";
    
    // Insert into database
    $stmt = $conn->prepare("
        INSERT INTO crypto_wallets (user_id, network, currency, address, qr_code, private_key, balance, is_real_blockchain, private_key_encrypted)
        VALUES (?, ?, ?, ?, ?, ?, 0, 1, ?)
    ");
    
    $result = $stmt->execute([
        1,
        'trc20',
        'USDT',
        $walletData['address'],
        $walletData['qr_code'],
        $walletData['private_key'],
        $walletData['private_key']
    ]);
    
    if ($result) {
        $walletId = $conn->lastInsertId();
        echo "Wallet inserted successfully. ID: $walletId\n";
    } else {
        echo "Failed to insert wallet\n";
        print_r($stmt->errorInfo());
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . " Line: " . $e->getLine() . "\n";
}
?>

